USE [JasmineLocal]
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CustomersCOA]') AND type in (N'U'))
CREATE TABLE [dbo].[CustomersCOA](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Account_ID] [bigint] NOT NULL,
	[Parent_ID] [bigint] NOT NULL,
	[Group_ID] [bigint] NOT NULL,
	[Account_Name] [nvarchar](255) NOT NULL,
	[Account_Name_SL] [nvarchar](255) NULL,
	[Account_Nature] [nvarchar](50) NOT NULL,
	[Remarks] [nvarchar](255) NULL,
	[isActive] [bit] NOT NULL,
	[isProtected] [bit] NOT NULL,
	[CanAddChild] [bit] NOT NULL,
 CONSTRAINT [PK_CustomersCOA] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Account_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[OrdersDetails]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[OrdersDetails](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Outlet_ID] [bigint] NOT NULL,
	[Master_ID] [bigint] NOT NULL,
	[Detail_ID] [bigint] NOT NULL,
	[Working_Date] [datetime] NOT NULL,
	[Added_DateTime] [datetime] NOT NULL,
	[Added_By] [nvarchar](255) NOT NULL,
	[Sent_DateTime] [datetime] NULL,
	[Sent_By] [nvarchar](255) NULL,
	[Category_Kind] [nvarchar](50) NOT NULL,
	[Category_ID] [bigint] NOT NULL,
	[Item_ID] [bigint] NOT NULL,
	[Item_Name_PL] [nvarchar](255) NOT NULL,
	[Item_Name_SL] [nvarchar](255) NOT NULL,
	[Item_Cost] [decimal](10, 3) NOT NULL,
	[Item_Price] [decimal](10, 3) NOT NULL,
	[Item_Selective_Tax_Amount] [decimal](8, 3) NOT NULL,
	[Item_TaxedPrice] [decimal](8, 3) NOT NULL,
	[Item_Qty] [int] NOT NULL,
	[withRemarks] [bit] NOT NULL,
	[Remarks] [nvarchar](max) NULL,
	[AddOns_IDs] [nvarchar](max) NULL,
	[AddOns_Names_PL] [nvarchar](max) NULL,
	[AddOns_Names_SL] [nvarchar](max) NULL,
	[Seat_No] [int] NOT NULL,
	[isComplementary] [bit] NOT NULL,
	[isCustody] [bit] NOT NULL,
	[isPrinted] [bit] NOT NULL,
	[isServed] [bit] NOT NULL,
	[isVoided] [bit] NOT NULL,
	[Voided_By] [nvarchar](255) NULL,
	[Revenue_Account] [bigint] NOT NULL,
	[Expenses_Account] [bigint] NOT NULL,
	[isSent] [bit] NOT NULL,
	[Cost_Policy] [nvarchar](50) NULL,
	[Recipe_ID] [bigint] NULL,
	[RawItem_ID] [bigint] NULL,
 CONSTRAINT [PK_OrdersDetails] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Outlet_ID] ASC,
	[Master_ID] ASC,
	[Detail_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[MenusAddOns]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[MenusAddOns](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Menu_ID] [bigint] NOT NULL,
	[AddOn_ID] [bigint] NOT NULL,
	[Display_Order] [bigint] NOT NULL,
	[isActive] [bit] NOT NULL,
	[AddOn_Name_PL] [nvarchar](255) NOT NULL,
	[AddOn_Name_SL] [nvarchar](255) NOT NULL,
	[Price] [decimal](10, 3) NOT NULL,
	[Cost] [decimal](10, 3) NOT NULL,
	[Cost_Policy] [nvarchar](50) NULL,
	[Recipe_ID] [bigint] NULL,
	[RawItem_ID] [bigint] NULL,
 CONSTRAINT [PK_MenusAddOns] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Menu_ID] ASC,
	[AddOn_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  View [dbo].[SoldModifiersView]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


CREATE VIEW [dbo].[SoldModifiersView]
AS
Select t1.Customer_ID, t1.Restaurant_ID, t1.Outlet_ID, t1.Working_Date, t1.AddOn_ID, MenusAddOns.AddOn_Name_PL, MenusAddOns.AddOn_Name_SL, MenusAddOns.Price, MenusAddOns.Cost_Policy, isNull(MenusAddOns.RawItem_ID, 0) RawItem_ID, isNull(MenusAddOns.Recipe_ID, 0) Recipe_ID
From
(Select Customer_ID, Restaurant_ID, Outlet_ID, Working_Date, value as AddOn_ID 
From OrdersDetails CROSS APPLY STRING_SPLIT(AddOns_IDs, ',') Where Len(AddOns_IDs) > 0) t1
Left Outer Join MenusAddOns
On t1.AddOn_ID = MenusAddOns.AddOn_ID  
GO
/****** Object:  Table [dbo].[OrdersMaster]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[OrdersMaster](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Outlet_ID] [bigint] NOT NULL,
	[Master_ID] [bigint] NOT NULL,
	[Order_Seq] [int] NOT NULL,
	[Order_Kind] [int] NOT NULL,
	[Order_Origin] [int] NOT NULL,
	[Working_Date] [datetime] NOT NULL,
	[Open_DateTime] [datetime] NOT NULL,
	[Close_DateTime] [datetime] NULL,
	[Waiter_Name] [nvarchar](255) NOT NULL,
	[Cashier_Name] [nvarchar](255) NULL,
	[Driver_Name] [nvarchar](255) NULL,
	[Address_ID] [bigint] NOT NULL,
	[Company_ID] [bigint] NOT NULL,
	[DT_ID] [bigint] NOT NULL,
	[Financial_Status] [nvarchar](50) NOT NULL,
	[Kitchen_Status] [nvarchar](50) NOT NULL,
	[Order_PayOption] [nvarchar](255) NOT NULL,
	[Order_Upper_Line] [nvarchar](50) NOT NULL,
	[Order_Downer_Line] [nvarchar](50) NOT NULL,
	[Master_Remarks] [nvarchar](max) NULL,
	[Order_ItemsQty] [int] NULL,
	[Value_Grand] [decimal](12, 3) NULL,
	[Delivery_Charges] [decimal](10, 3) NOT NULL,
	[Value_With_Delivery_Charges] [decimal](10, 3) NOT NULL,
	[Discount] [decimal](12, 3) NULL,
	[Value_After_Discount] [decimal](10, 3) NOT NULL,
	[Tax_VAT] [decimal](12, 3) NULL,
	[Value_Net] [decimal](12, 3) NULL,
	[Account_ID] [bigint] NOT NULL,
	[Customer_Cash] [decimal](12, 3) NULL,
	[Customer_Change] [decimal](12, 3) NULL,
	[Order_Covers] [int] NULL,
	[Order_Selective_TAX] [decimal](12, 3) NULL,
	[Order_Tips] [decimal](12, 3) NULL,
	[Tentative_Cost] [decimal](10, 3) NULL,
	[Discount_Remarks] [nvarchar](255) NULL,
	[DC_Customer_Name] [nvarchar](50) NULL,
	[DC_Customer_Mobile] [nvarchar](50) NULL,
 CONSTRAINT [PK_OrdersMaster] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Outlet_ID] ASC,
	[Master_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[OrdersKinds]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[OrdersKinds](
	[Kind_ID] [bigint] NOT NULL,
	[Kind_Desc_PL] [nvarchar](50) NOT NULL,
	[Kind_Desc_SL] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_OrdersKinds] PRIMARY KEY CLUSTERED 
(
	[Kind_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  View [dbo].[OrdersMasterView]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


CREATE   VIEW [dbo].[OrdersMasterView]
AS
SELECT Master_ID
,OM.Customer_ID
,OM.Restaurant_ID
,OM.Outlet_ID
,Order_Seq
,Order_Kind
,OrdersKinds.Kind_Desc_PL AS Order_Kind_Desc
,Order_Origin
,Working_Date
,Open_DateTime
,Close_DateTime
,Waiter_Name
,Cashier_Name
,Driver_Name
,Company_ID
,DT_ID
,Financial_Status
,Kitchen_Status
,Order_PayOption
,Order_Upper_Line
,Order_Downer_Line
,Master_Remarks
,Order_ItemsQty
,Value_Grand
,Delivery_Charges
,Value_With_Delivery_Charges
,Discount
,Value_After_Discount
,Tax_VAT
,Value_Net      
,Customer_Cash
,Customer_Change
,Order_Covers
,Order_Selective_TAX
,Order_Tips
,Tentative_Cost
,OM.Account_ID
,Discount_Remarks
,DC_Customer_Name
,DC_Customer_Mobile
FROM  dbo.OrdersMaster AS OM  
Left Outer Join OrdersKinds
On OM.Order_Kind = OrdersKinds.Kind_ID
GO
/****** Object:  View [dbo].[ItemsInOrder]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


CREATE VIEW [dbo].[ItemsInOrder]
AS
SELECT Master_ID, Item_ID, Sum(Item_Qty) AS QTY, SUM(Item_Cost) AS Cost, SUM(Item_Price) AS Price, SUM(Item_Selective_Tax_Amount) AS Selective_TAX_Amount, SUM(Item_TaxedPrice) AS TaxedPrice
FROM   dbo.OrdersDetails
GROUP BY Master_ID, Item_ID
GO
/****** Object:  Table [dbo].[MenusItemsTags]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[MenusItemsTags](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Menu_ID] [bigint] NOT NULL,
	[Item_ID] [bigint] NOT NULL,
	[Tag_Code] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_MenusItemsTags] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Menu_ID] ASC,
	[Item_ID] ASC,
	[Tag_Code] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[AppTags]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[AppTags](
	[Tag_Code] [nvarchar](50) NOT NULL,
	[Tag_Description_PL] [nvarchar](50) NOT NULL,
	[Tag_Kind] [nvarchar](50) NOT NULL,
	[Tag_Description_SL] [nvarchar](50) NULL,
 CONSTRAINT [PK_AppTags] PRIMARY KEY CLUSTERED 
(
	[Tag_Code] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  View [dbo].[MenusItemsTags_View]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [dbo].[MenusItemsTags_View]
AS
SELECT MIT.Item_ID, MIT.Tag_Code, dbo.AppTags.Tag_Description_PL, dbo.AppTags.Tag_Description_SL, dbo.AppTags.Tag_Kind
FROM   dbo.MenusItemsTags AS MIT LEFT OUTER JOIN
             dbo.AppTags ON MIT.Tag_Code = dbo.AppTags.Tag_Code
GO
/****** Object:  Table [dbo].[AfterKitchenVoids]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[AfterKitchenVoids](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Outlet_ID] [bigint] NOT NULL,
	[AKV_ID] [bigint] NOT NULL,
	[Void_WorkingDate] [datetime] NOT NULL,
	[Void_DateTime] [datetime] NOT NULL,
	[Void_By] [nvarchar](255) NOT NULL,
	[Void_Reason] [nvarchar](255) NOT NULL,
	[Master_Seq] [int] NOT NULL,
	[Master_ID] [bigint] NOT NULL,
	[Item_ID] [bigint] NOT NULL,
	[Item_Name] [nvarchar](1024) NOT NULL,
	[Item_Price] [decimal](8, 3) NOT NULL,
	[isPrinted] [bit] NOT NULL,
	[isServed] [bit] NOT NULL,
	[withRemarks] [bit] NOT NULL,
	[Remarks] [nvarchar](255) NULL,
	[isNoted] [bit] NOT NULL,
 CONSTRAINT [PK_AfterKitchenVoids] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Outlet_ID] ASC,
	[AKV_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[DinnerSections]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DinnerSections](
	[Section_ID] [bigint] IDENTITY(1,1) NOT NULL,
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Outlet_ID] [bigint] NOT NULL,
	[Section_Name] [nvarchar](255) NOT NULL,
	[isActive] [bit] NOT NULL,
 CONSTRAINT [PK_DinnerSections] PRIMARY KEY CLUSTERED 
(
	[Section_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[DinnerTables]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DinnerTables](
	[DT_ID] [bigint] IDENTITY(1,1) NOT NULL,
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Outlet_ID] [bigint] NOT NULL,
	[Section_ID] [bigint] NOT NULL,
	[DT_Name] [nvarchar](32) NOT NULL,
	[DT_Seats] [bigint] NOT NULL,
	[isActive] [bit] NOT NULL,
	[isOccupied] [bit] NOT NULL,
 CONSTRAINT [PK_DinnerTables] PRIMARY KEY CLUSTERED 
(
	[DT_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[KitchenStations]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[KitchenStations](
	[Station_ID] [bigint] IDENTITY(1,1) NOT NULL,
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Outlet_ID] [bigint] NOT NULL,
	[Station_Name] [nvarchar](50) NOT NULL,
	[isActive] [bit] NOT NULL,
 CONSTRAINT [PK_KitchenStations] PRIMARY KEY CLUSTERED 
(
	[Station_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Menus]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Menus](
	[Menu_ID] [bigint] IDENTITY(1,1) NOT NULL,
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Display_Name] [nvarchar](512) NOT NULL,
	[isDefault] [bit] NOT NULL,
 CONSTRAINT [PK_Menus] PRIMARY KEY CLUSTERED 
(
	[Menu_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[MenusAnnouncements]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[MenusAnnouncements](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Menu_ID] [bigint] NOT NULL,
	[Announcement_ID] [bigint] NOT NULL,
	[Display_Order] [bigint] NOT NULL,
	[Active] [bit] NOT NULL,
	[Description] [nvarchar](50) NOT NULL,
	[Image_FileName] [nvarchar](255) NULL,
	[Image_URL] [nvarchar](255) NULL,
 CONSTRAINT [PK_MenusAnnouncements] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Menu_ID] ASC,
	[Announcement_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[MenusCategories]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[MenusCategories](
	[Category_ID] [bigint] IDENTITY(1,1) NOT NULL,
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Menu_ID] [bigint] NOT NULL,
	[Display_Order] [bigint] NOT NULL,
	[isActive] [bit] NOT NULL,
	[Category_Name_PL] [nvarchar](255) NULL,
	[Category_Name_SL] [nvarchar](255) NULL,
	[Show_Image] [bit] NOT NULL,
	[Image_FileName] [nvarchar](512) NULL,
	[Image_URL] [nvarchar](255) NULL,
 CONSTRAINT [PK_MenusCategories] PRIMARY KEY CLUSTERED 
(
	[Category_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[MenusItems]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[MenusItems](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Menu_ID] [bigint] NOT NULL,
	[Item_ID] [bigint] NOT NULL,
	[Category_Kind] [nvarchar](50) NOT NULL,
	[Revenue_Account] [bigint] NOT NULL,
	[Cost_Account] [bigint] NOT NULL,
	[isActive] [bit] NOT NULL,
	[isPublished] [bit] NOT NULL,
	[Show_New_Meal] [bit] NULL,
	[Show_Special] [bit] NULL,
	[Item_Name_PL] [nvarchar](255) NOT NULL,
	[Item_Name_SL] [nvarchar](255) NOT NULL,
	[Item_Desc_PL] [nvarchar](512) NULL,
	[Item_Desc_SL] [nvarchar](512) NULL,
	[Selling_Method] [nvarchar](50) NULL,
	[Balance_Policy] [nvarchar](50) NULL,
	[Preparation_Period] [int] NOT NULL,
	[Price] [decimal](10, 3) NOT NULL,
	[Cost] [decimal](10, 3) NOT NULL,
	[Selective_TAX_Percentage] [decimal](8, 3) NOT NULL,
	[Taxed_Price] [decimal](8, 3) NOT NULL,
	[Under_Promotion] [bit] NOT NULL,
	[Promotion_Price] [decimal](8, 3) NOT NULL,
	[Promotion_Taxed_Price] [decimal](8, 3) NOT NULL,
	[Promotion_Start_Date] [datetime] NULL,
	[Promotion_End_Date] [datetime] NULL,
	[Promotion_Full_Day] [bit] NULL,
	[Promotion_Start_Time] [datetime] NULL,
	[Promotion_Duration] [int] NULL,
	[Show_Image] [bit] NOT NULL,
	[Image_FileName] [nvarchar](255) NULL,
	[Image_URL] [nvarchar](255) NULL,
	[Show_Video] [bit] NOT NULL,
	[Video_FileName] [nvarchar](255) NULL,
	[Video_URL] [nvarchar](255) NULL,
	[isFiller] [bit] NOT NULL,
	[Dinein_Only] [bit] NOT NULL,
	[Show_Meat_Origin] [bit] NOT NULL,
	[Meat_Origin_PL] [nvarchar](512) NULL,
	[Meat_Origin_SL] [nvarchar](512) NULL,
	[Show_Nutrition_Values] [bit] NOT NULL,
	[Calories] [decimal](10, 2) NULL,
	[Total_Fat] [decimal](10, 2) NULL,
	[Saturated_Fat] [decimal](10, 2) NULL,
	[Cholesterol] [decimal](10, 2) NULL,
	[Sodium] [decimal](10, 2) NULL,
	[Carbonhydrates] [decimal](10, 2) NULL,
	[Sugars] [decimal](10, 2) NULL,
	[Fiber] [decimal](10, 2) NULL,
	[Protein] [decimal](10, 2) NULL,
	[Changed_By] [nvarchar](255) NOT NULL,
	[Changed_Date] [datetime] NOT NULL,
	[Cost_Policy] [nvarchar](50) NULL,
	[Recipe_ID] [bigint] NULL,
	[RawItem_ID] [bigint] NULL,
	[Allow_Open_Price] [bit] NULL,
 CONSTRAINT [PK_MenusItems] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Menu_ID] ASC,
	[Item_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[MenusItemsInCategories]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[MenusItemsInCategories](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Menu_ID] [bigint] NOT NULL,
	[Category_ID] [bigint] NOT NULL,
	[Item_ID] [bigint] NOT NULL,
	[Display_Order] [bigint] NOT NULL,
 CONSTRAINT [PKMenusItemsInCategories] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Menu_ID] ASC,
	[Category_ID] ASC,
	[Item_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[MenusItemsInStations]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[MenusItemsInStations](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Menu_ID] [bigint] NOT NULL,
	[Station_ID] [bigint] NOT NULL,
	[Item_ID] [bigint] NOT NULL,
 CONSTRAINT [PK_MenusItemsInStations] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Menu_ID] ASC,
	[Station_ID] ASC,
	[Item_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[MenusItemsModifiersSets]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[MenusItemsModifiersSets](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Menu_ID] [bigint] NOT NULL,
	[Item_ID] [bigint] NOT NULL,
	[Set_ID] [bigint] NOT NULL,
	[Set_Title] [nvarchar](255) NOT NULL,
	[Display_Order] [bigint] NOT NULL,
	[Min_Choice] [int] NOT NULL,
	[Max_Choice] [int] NOT NULL,
	[Message_Waiter] [nvarchar](255) NOT NULL,
	[Message_Customer_SL] [nvarchar](255) NULL,
	[Message_Customer_PL] [nvarchar](255) NULL,
 CONSTRAINT [PK_MenusItemsModifiersSets] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Menu_ID] ASC,
	[Item_ID] ASC,
	[Set_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[MenusModifiersInSets]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[MenusModifiersInSets](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Menu_ID] [bigint] NOT NULL,
	[Set_ID] [bigint] NOT NULL,
	[AddOn_ID] [bigint] NOT NULL,
 CONSTRAINT [PK_MenusModifiersInSets] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Menu_ID] ASC,
	[Set_ID] ASC,
	[AddOn_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[MenusModifiersSets]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[MenusModifiersSets](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Menu_ID] [bigint] NOT NULL,
	[Set_ID] [bigint] NOT NULL,
	[isActive] [bit] NOT NULL,
	[Set_Name_PL] [nvarchar](50) NOT NULL,
	[Set_Name_SL] [nvarchar](50) NOT NULL,
	[Description] [nvarchar](255) NULL,
 CONSTRAINT [PK_MenusModifiersSets] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Menu_ID] ASC,
	[Set_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[OrdersDetailsAddOns]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[OrdersDetailsAddOns](
	[Rec_ID] [bigint] IDENTITY(1,1) NOT NULL,
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Outlet_ID] [bigint] NOT NULL,
	[Master_ID] [bigint] NOT NULL,
	[Detail_ID] [bigint] NOT NULL,
	[Working_Date] [datetime] NOT NULL,
	[AddOn_ID] [bigint] NOT NULL,
	[AddOn_Name_PL] [nvarchar](255) NOT NULL,
	[AddOn_Name_SL] [nvarchar](255) NOT NULL,
	[AddOn_Cost] [decimal](10, 3) NOT NULL,
	[AddOn_Price] [decimal](10, 3) NOT NULL,
	[Item_Qty] [int] NOT NULL,
	[isComplementary] [bit] NOT NULL,
	[Cost_Policy] [nvarchar](50) NULL,
	[Recipe_ID] [bigint] NULL,
	[RawItem_ID] [bigint] NULL,
 CONSTRAINT [PK_OrdersDetailsAddOns] PRIMARY KEY CLUSTERED 
(
	[Rec_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[OrdersPayments]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[OrdersPayments](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Outlet_ID] [bigint] NOT NULL,
	[Master_ID] [bigint] NOT NULL,
	[Payment_ID] [bigint] NOT NULL,
	[Working_Date] [datetime] NOT NULL,
	[Order_PayOption] [nvarchar](255) NOT NULL,
	[Account_ID] [bigint] NOT NULL,
	[Account_Name] [nvarchar](255) NOT NULL,
	[Amount] [decimal](12, 3) NOT NULL,
	[Cashier_Name] [nvarchar](255) NULL,
 CONSTRAINT [PK_OrdersPayments] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Outlet_ID] ASC,
	[Master_ID] ASC,
	[Payment_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[OutletsCounters]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[OutletsCounters](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Outlet_ID] [bigint] NOT NULL,
	[Counter_Kind] [nvarchar](50) NOT NULL,
	[Counter_Value] [bigint] NOT NULL,
	[Counter_Description] [nvarchar](255) NOT NULL,
	[Reset_At_Close_Day] [bit] NOT NULL,
 CONSTRAINT [PK_OutletsCounters] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Outlet_ID] ASC,
	[Counter_Kind] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PaymentMethods]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PaymentMethods](
	[Payment_Method] [nvarchar](255) NOT NULL,
	[Display_Order] [int] NOT NULL,
	[isActive] [bit] NOT NULL,
	[isProtected] [bit] NULL,
	[Account_ID] [bigint] NULL,
	[Transaction_Nature] [nvarchar](50) NULL,
 CONSTRAINT [PK_PaymentMethods] PRIMARY KEY CLUSTERED 
(
	[Payment_Method] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[POSGeneralSettings]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[POSGeneralSettings](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Outlet_ID] [bigint] NOT NULL,
	[Working_Date] [datetime] NOT NULL,
	[Printing_Options] [nvarchar](255) NOT NULL,
	[Use_Packaging_Printer] [bit] NOT NULL,
	[Packaging_Printer_Name] [nvarchar](255) NULL,
	[Print_Double_Check] [bit] NOT NULL,
	[Last_Closed_Day] [datetime] NULL,
	[Inventory_Account] [bigint] NULL,
	[Default_Store_ID] [bigint] NULL,
 CONSTRAINT [PK_POSGeneralSettings] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Outlet_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[PrintersInPackaging]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[PrintersInPackaging](
	[Rec_ID] [bigint] IDENTITY(1,1) NOT NULL,
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Outlet_ID] [bigint] NOT NULL,
	[Printer_Name] [nvarchar](255) NOT NULL,
 CONSTRAINT [PK_PrintersInPackaging] PRIMARY KEY CLUSTERED 
(
	[Rec_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ReadyToPrint]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ReadyToPrint](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Outlet_ID] [bigint] NOT NULL,
	[RTP_ID] [bigint] NOT NULL,
	[Master_ID] [bigint] NOT NULL,
 CONSTRAINT [PK_ReadyToPrint] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Outlet_ID] ASC,
	[RTP_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ReOpenedOrders]    Script Date: 15/03/2022 2:13:16 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ReOpenedOrders](
	[Customer_ID] [bigint] NOT NULL,
	[Restaurant_ID] [bigint] NOT NULL,
	[Outlet_ID] [bigint] NOT NULL,
	[ROO_ID] [bigint] NOT NULL,
	[Master_ID] [bigint] NOT NULL,
	[Working_Date] [datetime] NOT NULL,
	[ReOpen_DateTime] [datetime] NOT NULL,
	[ReOpen_By] [nvarchar](255) NOT NULL,
	[ReOpen_Reason] [nvarchar](255) NOT NULL,
 CONSTRAINT [PK_ReOpenedOrders] PRIMARY KEY CLUSTERED 
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Outlet_ID] ASC,
	[ROO_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING ON
GO

/****** Object:  View [dbo].[OrdersDetailsStationsView]    Script Date: 19/03/2022 5:51:59 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE   VIEW [dbo].[OrdersDetailsStationsView]
AS
SELECT [Customer_ID]
,[Restaurant_ID]
,[Outlet_ID]
,[Master_ID]
,[Detail_ID]
,[Working_Date]
,[Added_DateTime]
,[Added_By]
,[Sent_DateTime]
,[Sent_By]
,[Category_Kind]
,[Category_ID]
,[Item_ID]
,[Item_Name_PL]
,[Item_Name_SL]
,[Item_Cost]
,[Item_Price]
,[Item_Selective_Tax_Amount]
,[Item_TaxedPrice]
,[Item_Qty]
,[withRemarks]
,[Remarks]
,[AddOns_IDs]
,[AddOns_Names_PL]
,[AddOns_Names_SL]
,[Seat_No]
,[isComplementary]
,[isCustody]
,[isPrinted]
,[isServed]
,[isVoided]
,[Voided_By]
,[Revenue_Account]
,[Expenses_Account]
,[isSent]
,[Cost_Policy]
,[Recipe_ID]
,[RawItem_ID]
,Concat(Item_Name_PL, Case When AddOns_Names_PL='' then null else CHAR(13)+CHAR(10) + N'Add-Ons:' + NullIF(Replace(AddOns_Names_PL, '#', CHAR(13)+CHAR(10)), '') end) Displayed_Name_PL
,Concat(Item_Name_SL, Case When AddOns_Names_SL='' then null else CHAR(13)+CHAR(10) + N'������:' + NullIF(Replace(AddOns_Names_SL, '#', CHAR(13)+CHAR(10)), '') end) Displayed_Name_SL
FROM [dbo].[OrdersDetails]
GO

/****** Object:  Index [OutletsCounters_NonClusteredIndex]    Script Date: 15/03/2022 2:13:16 PM ******/
CREATE NONCLUSTERED INDEX [OutletsCounters_NonClusteredIndex] ON [dbo].[OutletsCounters]
(
	[Customer_ID] ASC,
	[Restaurant_ID] ASC,
	[Outlet_ID] ASC,
	[Counter_Kind] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
GO
ALTER TABLE [dbo].[DinnerSections] ADD  CONSTRAINT [DF_DinnerSections_isActive]  DEFAULT ((1)) FOR [isActive]
GO
ALTER TABLE [dbo].[DinnerTables] ADD  CONSTRAINT [DF_DinnerTables_isActive]  DEFAULT ((1)) FOR [isActive]
GO
ALTER TABLE [dbo].[DinnerTables] ADD  CONSTRAINT [DF_DinnerTables_isOccupied]  DEFAULT ((0)) FOR [isOccupied]
GO
ALTER TABLE [dbo].[Menus] ADD  CONSTRAINT [DF_Menus_isDefault]  DEFAULT ((0)) FOR [isDefault]
GO
ALTER TABLE [dbo].[MenusAddOns] ADD  CONSTRAINT [DF_MenusAddOns_Cost_Policy]  DEFAULT (N'Fixed Cost') FOR [Cost_Policy]
GO
ALTER TABLE [dbo].[MenusAddOns] ADD  CONSTRAINT [DF_MenusAddOns_Recipe_ID]  DEFAULT ((0)) FOR [Recipe_ID]
GO
ALTER TABLE [dbo].[MenusAddOns] ADD  CONSTRAINT [DF_MenusAddOns_RawItem_ID]  DEFAULT ((0)) FOR [RawItem_ID]
GO
ALTER TABLE [dbo].[MenusItems] ADD  CONSTRAINT [DF_MenusItems_Cost_Policy]  DEFAULT (N'Fixed Cost') FOR [Cost_Policy]
GO
ALTER TABLE [dbo].[MenusItems] ADD  CONSTRAINT [DF_MenusItems_Recipe_ID]  DEFAULT ((0)) FOR [Recipe_ID]
GO
ALTER TABLE [dbo].[MenusItems] ADD  CONSTRAINT [DF_MenusItems_RawItem_ID]  DEFAULT ((0)) FOR [RawItem_ID]
GO
ALTER TABLE [dbo].[OrdersDetails] ADD  CONSTRAINT [DF_OrdersDetails_Item_Cost]  DEFAULT ((0)) FOR [Item_Cost]
GO
ALTER TABLE [dbo].[OrdersDetails] ADD  CONSTRAINT [DF_OrdersDetails_Item_Price]  DEFAULT ((0)) FOR [Item_Price]
GO
ALTER TABLE [dbo].[OrdersDetails] ADD  CONSTRAINT [DF_OrdersDetails_withRemarks]  DEFAULT ((0)) FOR [withRemarks]
GO
ALTER TABLE [dbo].[OrdersDetails] ADD  CONSTRAINT [DF_OrdersDetails_Seat_No]  DEFAULT ((0)) FOR [Seat_No]
GO
ALTER TABLE [dbo].[OrdersDetails] ADD  CONSTRAINT [DF_OrdersDetails_isComplementary]  DEFAULT ((0)) FOR [isComplementary]
GO
ALTER TABLE [dbo].[OrdersDetails] ADD  CONSTRAINT [DF_OrdersDetails_isCustody]  DEFAULT ((0)) FOR [isCustody]
GO
ALTER TABLE [dbo].[OrdersDetails] ADD  CONSTRAINT [DF_OrdersDetails_isPrinted]  DEFAULT ((0)) FOR [isPrinted]
GO
ALTER TABLE [dbo].[OrdersDetails] ADD  CONSTRAINT [DF_OrdersDetails_isServed]  DEFAULT ((0)) FOR [isServed]
GO
ALTER TABLE [dbo].[OrdersDetails] ADD  CONSTRAINT [DF_OrdersDetails_isVoided]  DEFAULT ((0)) FOR [isVoided]
GO
ALTER TABLE [dbo].[OrdersDetails] ADD  CONSTRAINT [DF_OrdersDetails_isSent]  DEFAULT ((0)) FOR [isSent]
GO
ALTER TABLE [dbo].[OrdersDetails] ADD  CONSTRAINT [DF_OrdersDetails_Cost_Policy]  DEFAULT (N'Fixed Cost') FOR [Cost_Policy]
GO
ALTER TABLE [dbo].[OrdersDetails] ADD  CONSTRAINT [DF_OrdersDetails_Recipe_ID]  DEFAULT ((0)) FOR [Recipe_ID]
GO
ALTER TABLE [dbo].[OrdersDetails] ADD  CONSTRAINT [DF_OrdersDetails_RawItem_ID]  DEFAULT ((0)) FOR [RawItem_ID]
GO
ALTER TABLE [dbo].[OrdersDetailsAddOns] ADD  CONSTRAINT [DF_OrdersDetailsAddOns_AddOn_Cost]  DEFAULT ((0)) FOR [AddOn_Cost]
GO
ALTER TABLE [dbo].[OrdersDetailsAddOns] ADD  CONSTRAINT [DF_OrdersDetailsAddOns_AddOn_Price]  DEFAULT ((0)) FOR [AddOn_Price]
GO
ALTER TABLE [dbo].[OrdersDetailsAddOns] ADD  CONSTRAINT [DF_OrdersDetailsAddOns_isComplementary]  DEFAULT ((0)) FOR [isComplementary]
GO
ALTER TABLE [dbo].[OrdersDetailsAddOns] ADD  CONSTRAINT [DF_OrdersDetailsAddOns_Cost_Policy]  DEFAULT (N'Fixed Cost') FOR [Cost_Policy]
GO
ALTER TABLE [dbo].[OrdersDetailsAddOns] ADD  CONSTRAINT [DF_OrdersDetailsAddOns_Recipe_ID]  DEFAULT ((0)) FOR [Recipe_ID]
GO
ALTER TABLE [dbo].[OrdersDetailsAddOns] ADD  CONSTRAINT [DF_OrdersDetailsAddOns_RawItem_ID]  DEFAULT ((0)) FOR [RawItem_ID]
GO
ALTER TABLE [dbo].[OrdersMaster] ADD  CONSTRAINT [DF_OrdersMaster_Address_ID]  DEFAULT ((0)) FOR [Address_ID]
GO
ALTER TABLE [dbo].[OrdersMaster] ADD  CONSTRAINT [DF_OrdersMaster_Company_ID]  DEFAULT ((0)) FOR [Company_ID]
GO
ALTER TABLE [dbo].[OrdersMaster] ADD  CONSTRAINT [DF_OrdersMaster_Tax_VAT]  DEFAULT ((0)) FOR [Tax_VAT]
GO
ALTER TABLE [dbo].[OrdersMaster] ADD  CONSTRAINT [DF_OrdersMaster_Customer_Cash]  DEFAULT ((0)) FOR [Customer_Cash]
GO
ALTER TABLE [dbo].[OrdersMaster] ADD  CONSTRAINT [DF_OrdersMaster_Customer_Change]  DEFAULT ((0)) FOR [Customer_Change]
GO
ALTER TABLE [dbo].[OrdersMaster] ADD  CONSTRAINT [DF_OrdersMaster_Order_Covers]  DEFAULT ((1)) FOR [Order_Covers]
GO
ALTER TABLE [dbo].[OrdersMaster] ADD  CONSTRAINT [DF_OrdersMaster_Order_Selective_TAX]  DEFAULT ((0)) FOR [Order_Selective_TAX]
GO
ALTER TABLE [dbo].[OrdersMaster] ADD  CONSTRAINT [DF_OrdersMaster_Order_Tips]  DEFAULT ((0)) FOR [Order_Tips]
GO
ALTER TABLE [dbo].[OutletsCounters] ADD  CONSTRAINT [DF_OutletsCounters_Reset_At_Close_Day]  DEFAULT ((0)) FOR [Reset_At_Close_Day]
GO
